<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package sakk
 */

?>
<!doctype html >
<html <?php language_attributes(); ?> class="no-js">
<head>
 <meta name="description" content="">
        <meta name="keywords" content="">
        <meta charset="utf-8">
        <meta name="author" content="Hadeer Magdy">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title><?php if(is_home() && is_front_page()){ ?>
        <?php bloginfo('name');?>  <?php bloginfo('description');?>
        <?php } else{?>
        <?php  bloginfo('name');?>  <?php wp_title();?>
        <?php }?></title>
     <link rel="shortcut icon" type="image/x-icon" href="<?php the_field('logo-mob', 'option'); ?>" />
        <link href="https://fonts.googleapis.com/css?family=Dosis:200,300,400,500,600,700,800" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css?family=Tajawal" rel="stylesheet">
        <link href="<?php echo get_template_directory_uri() ?>/assets/css/style.css" rel="stylesheet" type="text/css" />
	<?php if (qtranxf_getLanguage() == 'ar') : ?>
        <link href="<?php echo get_template_directory_uri() ?>/assets/css/bootstrap-rtl.min.css" rel="stylesheet" type="text/css" />
	 <?php endif; ?>
	<?php if (qtranxf_getLanguage() == 'en') : ?>
       <link href="<?php echo get_template_directory_uri() ?>/assets/css/style-en.css" rel="stylesheet" type="text/css" /> 
	 <?php endif; ?>
        <link href="<?php echo get_template_directory_uri() ?>/assets/css/mobile.css" rel="stylesheet" type="text/css" />

	<?php wp_head(); ?>
</head>

<body <?php // body_class(); ?>>
     <ul class="social-body">
            <li><a href="<?php the_field('face', 'option'); ?>"><i class="fab fa-facebook-f"></i></a></li>
            <li><a href="<?php the_field('twit', 'option'); ?>"><i class="fab fa-twitter"></i></a></li>
            <li><a href="<?php the_field('youtube', 'option'); ?>"><i class="fab fa-youtube"></i></a></li>
            <li><a href="<?php the_field('inst', 'option'); ?>"><i class="fab fa-instagram"></i></a></li> 
		 </li>
            <li><a href="<?php the_field('linked', 'option'); ?>"><i class="fab fa-linkedin-in"></i></a></li> 
	</li>
            <li><a href="<?php the_field('snap', 'option'); ?>"><i class="fab fa-snapchat-ghost"></i></a></li> 
        </ul>
        <!-- End SocialBody -->
        
        
        <!-- Start Header -->
        <?php if(is_home() && is_front_page()){ ?>
        <nav class="navbar navbar-inverse">
			<?php } else{?>
			<nav class="navbar navbar-inverse nav-in">
				<?php }?>
          	<div class="container">
            	<div class="navbar-header">
             		<button type="button" class="open-sidebar"><i class="fa fa-bars"></i></button>
					<?php echo qtranxf_generateLanguageSelectCode('text'); ?>
                    <a href="<?php echo site_url() ;?>" class="logo navbar-brand">
						<?php if(is_home() && is_front_page()){ ?>
                        <img src="<?php the_field('logo', 'option'); ?>" alt="">
						<?php } else{?>
						  <img src="<?php the_field('logo2', 'option'); ?>" alt="">
						<?php }?>
                    </a>
            	</div>
            	<div class="collapse navbar-collapse" id="myNavbar">
              		
						 <?php  wp_nav_menu(
      array(
       'menu'=>'prime', 'menu_class'=> '','items_wrap' => '<ul class="nav navbar-nav" >%3$s</ul>','container'=> ''
          )
    ); ?>  
                    <a href="#" class="search"><i class="fa fa-search"></i></a>
					<?php echo qtranxf_generateLanguageSelectCode('text'); ?>
            	</div>
          	</div>
            <!-- Start Sidebar -->
            <div class="overlay_gen"></div>
            <div class="sidebar">
                <div class="side-logo">
                    <a href="<?php echo site_url() ;?>">
                        <img src="<?php the_field('logo', 'option'); ?>" alt="">
                    </a>
                </div>
                <div class="side-social">
                    <ul>
                        <li>
                            <a href="<?php the_field('linked', 'option'); ?>" class="lin">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </li>
                        <li>
                            <a href="<?php the_field('twit', 'option'); ?>" class="tw">
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                        <li>
                            <a href="<?php the_field('inst', 'option'); ?>" class="ins">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="side-nav">
                   	 <?php  wp_nav_menu(
      array(
       'menu'=>'prime', 'menu_class'=> '','items_wrap' => '<ul>%3$s</ul>','container'=> ''
          )
    ); ?>  
                </div>
            </div>
            <!-- End Sidebar -->
        </nav>
        
        <!-- End Nav -->
            
        <!-- Start Search -->
        <section id="search">
            <div class="container">
				
					  <form role="search" method="get" id="searchform"
    class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
      <input name="s" type="text" name="search" placeholder="<?php _e('[:en]search ...[:ar]...ابحث'); ?>">
					 
                        <button type="submit"><i class="fa fa-search"></i></button>
                    </form>
             
            </div>
        </section>